//////////////////////////////////////////////
// BufferManager.js
//
//////////////////////////////////////////////

/// Class ------------------------------------
	
nkGraphicsTests.BufferManager = class BufferManager extends nkDebug.TestClass
{
	static instance = new BufferManager ("nkGraphicsTests.BufferManager") ;

	nkTests =
	{
		__testInit__ : function ()
		{
			// Init nkGraphics
			const s = nkGraphics.System.getInstance() ;

			const initResult = s.initialize() ;

			if (!initResult)
				console.log("Failure to initialize nkGraphics, bypassing BufferManager test...")

			return initResult ;
		},
		__testShutdown__ : function ()
		{
			nkGraphics.System.getInstance().shutdown()  ;
			nkGraphics.System.kill() ;
		},

		GetByIndexNoDuplicate : function ()
		{
			// Add some resources, some hidden, some not
			const resourceCount = 8 ;

			for (let i = 0 ; i < resourceCount ; ++i)
			{
				const c = nkGraphics.BufferManager.getInstance().createOrRetrieve(i.toString()) ;

				if (i % 2)
					c.setHidden(true) ;
			}

			// Go over the indices, check no double & hidden
			const set = new Set () ;

			for (let i = 0 ; i < resourceCount ; ++i)
			{
				const c = nkGraphics.BufferManager.getInstance().getByIndex(i) ;

				if (!c)
					break ;

				nkDebug.TestUtils.check(!c.getHidden(), "Got a hidden buffer") ;
				nkDebug.TestUtils.check(!set.has(c.getName()), "Got a buffer twice") ;

				set.add(c.getName()) ;
			}
		}
	}
}